package com.bytesbee.mysinglelivechannel.managers;

import android.app.Activity;
import android.content.Context;
import android.widget.TextView;

import com.bytesbee.mysinglelivechannel.R;
import com.bytesbee.mysinglelivechannel.activities.LoginActivity;
import com.kongzue.dialogx.dialogs.MessageDialog;


/**
 * Created by BytesBee.
 *
 * @author BytesBee
 * @link <a href="https://bytesbee.com">BytesBee</a>
 */
public class DialogManager {

    public static void checkEmptyFields(final String strMessage, final TextView txtView) {
        MessageDialog.build()
                .setTitle(R.string.err_validation_title)
                .setMessage(strMessage)
                .setCancelable(false)
                .setOkButton(R.string.ok, (baseDialog, v) -> {
                    txtView.requestFocus();
                    return false;
                })
                .show();

    }

    public static void showNoInternetDialog() {
        MessageDialog.build()
                .setTitle(R.string.warning)
                .setMessage(R.string.no_internet_text)
                .setCancelable(false)
                .setOkButton(R.string.ok, (baseDialog, v) -> false)
                .show();
    }

    public static void showOKDialog(final String strTitle, final String strMessage) {
        MessageDialog.build()
                .setTitle(strTitle)
                .setMessage(strMessage)
                .setCancelable(false)
                .setOkButton(R.string.ok, (baseDialog, v) -> false)
                .show();
    }

    public static void showOKDialog(final Context context, String strTitle, String strMessage, final boolean isActivityFinish) {
        MessageDialog.build()
                .setTitle(strTitle)
                .setMessage(strMessage)
                .setCancelable(false)
                .setOkButton(R.string.ok, (baseDialog, v) -> {
                    if (isActivityFinish) {
                        ((Activity) context).finish();
                    }
                    return false;
                })
                .show();
    }

    public static void showYesNoDialog(final Context context, String strTitle, String strMessage) {
        MessageDialog.build()
                .setTitle(strTitle)
                .setMessage(strMessage)
                .setCancelable(false)
                .setOkButton(R.string.yes, (baseDialog, v) -> {
                    SessionManager.get().clearAll();
                    Screens.showClearTopScreen(context, LoginActivity.class);
                    return true;
                })
                .setCancelButton(R.string.no, (baseDialog, v) -> false)
                .show();
    }
}
